#include <windows.h>

HWND CreateMainWindow(HINSTANCE hInstance);


LRESULT CALLBACK MessageHandler(HWND hwnd, UINT msg,
                             WPARAM wParam,
                             LPARAM lParam);

HWND hWnd = 0;

int WINAPI WinMain(HINSTANCE hInstance,
           HINSTANCE hPrevInstance,
           LPSTR lpCmdLine,
           int nCmdShow)
{
    hWnd = CreateMainWindow(hInstance);
    if(0 == hWnd)
    {
        MessageBox(0,"Fenster konnte nicht erzeugt werden",
                     "Fehler",MB_OK);
return 0;
    }

    MSG msg;

    while(GetMessage(&msg,NULL,0,0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    return 0;
}

HWND CreateMainWindow(HINSTANCE hInstance)
{
    WNDCLASSEX wndClass = {
        sizeof(WNDCLASSEX),
        CS_DBLCLKS | CS_OWNDC |
        CS_HREDRAW | CS_VREDRAW,
        MessageHandler,
        0,
        0,
        hInstance,
        LoadIcon(NULL, IDI_WINLOGO),
        LoadCursor(NULL, IDC_ARROW),
        (HBRUSH)GetStockObject(WHITE_BRUSH),
        NULL,
        "WindowClass",
        LoadIcon(NULL, IDI_WINLOGO)
    };

    RegisterClassEx(&wndClass);

    return CreateWindowEx(
    NULL,

    "WindowClass",
    "4brill.de - Gesicht",
    WS_OVERLAPPEDWINDOW |
    WS_VISIBLE,
    0,0,
    400, 300,
    NULL,

    NULL,
    hInstance,
    NULL);
}

LRESULT CALLBACK MessageHandler(HWND hwnd, UINT msg,
                                WPARAM wParam, LPARAM lParam)
{
    switch(msg)
    {
        case WM_DESTROY:
                    PostQuitMessage(0);
                    return 0;
                    break;

                    case WM_PAINT:
                    PAINTSTRUCT ps;
                    HDC hDC;

                    hDC = BeginPaint(hWnd,&ps);

                    HPEN PenRed    =CreatePen(PS_SOLID,3,RGB(255,0,0));
                    HPEN PenGreen  =CreatePen(PS_SOLID,2,RGB(255,0,0));
                    HPEN PenBlue   =CreatePen(PS_SOLID,1,RGB(255,0,0));

                    SelectObject(hDC,PenBlue);
                    Ellipse(hDC,60,5,340,250);
                    Ellipse(hDC,150,190,250,210);

                    SelectObject(hDC,PenGreen);
                    Rectangle(hDC,110,40,160,80);
                    Rectangle(hDC,240,40,290,80);

                    SelectObject(hDC,PenRed);
                    MoveToEx(hDC,200,120,NULL);
                    LineTo(hDC,180,150);
                    LineTo(hDC,220,150);
                    LineTo(hDC,200,120);

                    DeleteObject(PenRed);
                    DeleteObject(PenGreen);
                    DeleteObject(PenBlue);


                    EndPaint(hWnd,&ps);

                    return 0;
                    break;


    }

return (DefWindowProc(hwnd, msg, wParam, lParam));
}










